unit VCTOOL32;{24 Sept 2000, 4:00:10am}

interface

uses WinTypes, VCType32;

function VCLoadVCTOOL32: boolean;
procedure VCFreeVCTOOL32;
procedure VCAddPopupCommand (szNativeCmd: PChar; iPlacement: Smallint); stdcall;
procedure VCAdjoiningToMEP (var iError: Smallint); stdcall;
procedure VCAlignSelected; stdcall;
procedure VCAngularDim; stdcall;
procedure VCArc2Pt; stdcall;
procedure VCArc3Pt; stdcall;
procedure VCArrayCopySelected; stdcall;
procedure VCAttributeAttach; stdcall;
procedure VCAttributeCreate; stdcall;
procedure VCAttributeEdit; stdcall;
procedure VCAttributeEmbed; stdcall;
procedure VCAttributeMove; stdcall;
procedure VCAttributeMultiAttach; stdcall;
procedure VCBezEdit; stdcall;
procedure VCBezierSingle; stdcall;
procedure VCBooleanAdd (var iError: Smallint); stdcall;
procedure VCBooleanIntersect (var iError: Smallint); stdcall;
procedure VCBooleanSubtract (var iError: Smallint); stdcall;
procedure VCBoundaryFill; stdcall;
procedure VCBoundaryHatch; stdcall;
procedure VCChamfer; stdcall;
procedure VCChangeAtbDisplay (var iError: Smallint; tfDisplay: WordBool); stdcall;
procedure VCChangeAtbLabelDisplay (var iError: Smallint; tfDisplay: WordBool); stdcall;
procedure VCChangeSelected (var ea: EAttr); stdcall;
procedure VCChangeSymPlacementColor (var iError: Smallint; tfUsePlacementColor: WordBool; iNewColor: Smallint); stdcall;
procedure VCCircle2Pt; stdcall;
procedure VCCircle3Pt; stdcall;
procedure VCCircleDiameter; stdcall;
procedure VCClearDrawing (hW: Longint); stdcall;
procedure VCClearDrawingNoPrompt (hW: Longint); stdcall;
procedure VCContBezier; stdcall;
procedure VCCopySelected; stdcall;
procedure VCCopyToLayer (var iError: Smallint; iLayer: Smallint); stdcall;
procedure VCCornerTrim; stdcall;
function VCCreateOleClass (var iError: Smallint; OleDllName: PChar; OleClassName: PChar): Longint; stdcall;
procedure VCCurve; stdcall;
procedure VCDatum (var iError: Smallint); stdcall;
procedure VCDeleteOleClass (var iError: Smallint; id: Longint); stdcall;
procedure VCDeletePopupMenu (tf: WordBool); stdcall;
procedure VCDestroyContextMenu (var iError: Smallint; hMenu: Longword); stdcall;
procedure VCDiameterDim; stdcall;
procedure VCDigConfig; stdcall;
procedure VCDigDrawingAlign; stdcall;
procedure VCDimEdit; stdcall;
procedure VCDimMoveArc; stdcall;
procedure VCDimMoveLine; stdcall;
procedure VCDimMoveText; stdcall;
procedure VCDimPoint (var iError: Smallint); stdcall;
procedure VCDimSlideText; stdcall;
procedure VCDispatchCommand; stdcall;
procedure VCDispatchNextPoint; stdcall;
procedure VCDllRun (var iError: Smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar); stdcall;
procedure VCEdit; stdcall;
procedure VCEditAbort; stdcall;
procedure VCEditChange; stdcall;
procedure VCEditComplete; stdcall;
procedure VCEllipse; stdcall;
procedure VCEllipticalArcStartSpan; stdcall;
procedure VCEraseLast; stdcall;
procedure VCEraseSelected; stdcall;
procedure VCExplode; stdcall;
procedure VCExtend; stdcall;
procedure VCFillSelected; stdcall;
procedure VCFillet; stdcall;
procedure VCFitScaleSelected; stdcall;
function VCGetDatumMode (var iError: Smallint): Smallint; stdcall;
function VCGetCurrentToolContextMenu (var iError: Smallint; var hInMenu: Longword): WordBool; stdcall;
function VCGetPrompt (iPromptIndex: Smallint; szPrompt: PChar): Smallint; stdcall;
function VCGetRibbolog: Word; stdcall;
function VCGetToolID: Word; stdcall;
function VCGetUserToolState (var iError: Smallint): Smallint; stdcall;
procedure VCGridOrigin; stdcall;
procedure VCHatchSelected; stdcall;
procedure VCIrregularPolygon; stdcall;
procedure VCLeader; stdcall;
procedure VCLeaderEdit; stdcall;
procedure VCLike (hw: Longint; ch: Shortint); stdcall;
procedure VCLine; stdcall;
procedure VCLineContinuous; stdcall;
procedure VCLinearDim; stdcall;
procedure VCLoadAscii (var iError: Smallint; szAscii: PChar); stdcall;
procedure VCLoadLnt; stdcall;
procedure VCMButtonDown (lParam: Longint; wParam: Word); stdcall;
procedure VCMLine; stdcall;
procedure VCMatchEntity; stdcall;
procedure VCMatchTool; stdcall;
procedure VCMeasureAngle2; stdcall;
procedure VCMeasureAngle3; stdcall;
procedure VCMeasureArea; stdcall;
procedure VCMeasureDistance; stdcall;
procedure VCMerge (pName: PChar); stdcall;
procedure VCMergePolygonsTool (var iError: Smallint); stdcall;
procedure VCMirrorSelected; stdcall;
procedure VCModBreak; stdcall;
procedure VCMovePoint; stdcall;
procedure VCMoveSelected; stdcall;
procedure VCMoveToLayer (var iError: Smallint; iLayer: Smallint); stdcall;
procedure VCMultipleCopy; stdcall;
procedure VCNewHandle; stdcall;
procedure VCOffsetMEP (var iError: Smallint); stdcall;
procedure VCOffsetPnt; stdcall;
procedure VCOleClassMethodInvoke (var iError: Smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar); stdcall;
procedure VCOrdinateDim (var iError: Smallint); stdcall;
procedure VCPackData (hW: Longint); stdcall;
function VCPastable: WordBool; stdcall;
procedure VCPaste; stdcall;
procedure VCPlaceCurrentSymbol; stdcall;
procedure VCPoint; stdcall;
procedure VCPopupButton (lParam: Longint; wParam: Word); stdcall;
procedure VCPurgeLnt; stdcall;
procedure VCRButtonDown (lParam: Longint; wParam: Word); stdcall;
procedure VCRFSize (var iError: Smallint); stdcall;
procedure VCRFZoomAll (var iError: Smallint); stdcall;
procedure VCRFZoomArea (var iError: Smallint); stdcall;
procedure VCRFZoomIn (var iError: Smallint); stdcall;
procedure VCRFZoomOut (var iError: Smallint); stdcall;
procedure VCRFZoomPan (var iError: Smallint); stdcall;
procedure VCRFZoomPrevious (var iError: Smallint); stdcall;
procedure VCRFZoomRegen (var iError: Smallint); stdcall;
procedure VCRFZoomValue (var iError: Smallint); stdcall;
procedure VCRFZoomView (var iError: Smallint); stdcall;
procedure VCRPolygonCenter; stdcall;
procedure VCRPolygonSide; stdcall;
procedure VCRadCopySelected; stdcall;
procedure VCRadialDim; stdcall;
procedure VCRectangle2Pt; stdcall;
procedure VCRectangle3Pt; stdcall;
procedure VCRedo; stdcall;
procedure VCRefFrameCreate (var iError: Smallint); stdcall;
procedure VCRefFramePlace (var iError: Smallint); stdcall;
procedure VCRegenArea; stdcall;
procedure VCReplaceSymbol (szFrom: PChar; szTo: PChar; tfSelectedOnly: WordBool); stdcall;
procedure VCRotateSelected; stdcall;
procedure VCRun (szName: PChar); stdcall;
procedure VCRunNested (szName: PChar); stdcall;
procedure VCRunNestedDll; stdcall;
procedure VCScaleSelected; stdcall;
procedure VCSeedFill; stdcall;
procedure VCSeedHatch; stdcall;
procedure VCSelect; stdcall;
procedure VCSelectAdjoining; stdcall;
procedure VCSelectCrossingWindow; stdcall;
procedure VCSelectLastEntity; stdcall;
procedure VCSelectLastObject (var iError: Smallint); stdcall;
procedure VCSelectObject; stdcall;
procedure VCSelectWindow; stdcall;
procedure VCSelectionExtend; stdcall;
procedure VCSelectionFilter (CmdID: Word; id: Word); stdcall;
procedure VCSelectionRibalog (id: Word); stdcall;
procedure VCSelectionTrim; stdcall;
procedure VCSelectionTrimSingleTarget (var iError: Smallint); stdcall;
procedure VCSetBasepoint; stdcall;
procedure VCSetDatumMode (var iError: Smallint; iMode: Smallint); stdcall;
function VCSetPrompt (iPromptIndex: Smallint; szPrompt: PChar): WordBool; stdcall;
procedure VCSetRibbolog (id: Word); stdcall;
procedure VCSetUserTool (iStates: Smallint; szNativeCmd: PChar; szFirstPrompt: PChar); stdcall;
procedure VCSetUserToolState (var iError: Smallint; iNewState: Smallint); stdcall;
procedure VCSnapArcCenter; stdcall;
procedure VCSnapCloseGeom; stdcall;
procedure VCSnapClosestPoint; stdcall;
procedure VCSnapEndPoint; stdcall;
procedure VCSnapInt; stdcall;
procedure VCSnapLastPoint (lParam: Longint; wParam: Word); stdcall;
procedure VCSnapMid2Points; stdcall;
procedure VCSnapMidPoint; stdcall;
procedure VCSnapNearPoint (lParam: Longint; wParam: Word); stdcall;
procedure VCSnapParallel; stdcall;
procedure VCSnapPercent; stdcall;
procedure VCSnapPerpendicular; stdcall;
procedure VCSnapQuad; stdcall;
procedure VCSnapTangent; stdcall;
procedure VCSpecificAttributeAttach (lParam: Longint); stdcall;
procedure VCSplitPolygonTool (var iError: Smallint); stdcall;
procedure VCStretchSelected; stdcall;
procedure VCSymbolCreate; stdcall;
procedure VCSymbolExplode; stdcall;
procedure VCSymbolPlace (szName: PChar); stdcall;
procedure VCTextManager; stdcall;
procedure VCTextTool; stdcall;
procedure VCTracking; stdcall;
procedure VCTrim; stdcall;
procedure VCUndo; stdcall;
procedure VCUndoLastVertex; stdcall;
procedure VCUpdateTool; stdcall;
procedure VCUserMatch (id: Word); stdcall;
procedure VCUserPoint; stdcall;
procedure VCWindowStretch; stdcall;
procedure VCZoomArea; stdcall;
procedure VCZoomIn; stdcall;
procedure VCZoomOut; stdcall;
procedure VCZoomPan; stdcall;
procedure VCZoomValue; stdcall;
function VCGetUserToolSnapable: WordBool; stdcall;
procedure VCSetUserToolSnapable (tf: WordBool); stdcall;
procedure VCDivide; stdcall;

implementation

var hInst: THandle;

function VCLoadVCTOOL32: boolean;
begin
  hInst := LoadLibrary('VCTOOL32.DLL');
  result := hInst <> 0;
end;

procedure VCFreeVCTOOL32;
begin
  if hInst <> 0 then
    FreeLibrary(hInst);
end;

procedure VCAddPopupCommand (szNativeCmd: PChar; iPlacement: Smallint);
type TVCProc = procedure (szNativeCmd: PChar; iPlacement: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPopupCommand');
    if @aproc <> nil then
      aproc(szNativeCmd, iPlacement);
  end;
end;

procedure VCAdjoiningToMEP (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAdjoiningToMEP');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCAlignSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAlignSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAngularDim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAngularDim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCArc2Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCArc2Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCArc3Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCArc3Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCArrayCopySelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCArrayCopySelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeAttach;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeAttach');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeCreate;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeCreate');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeEdit;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeEdit');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeEmbed;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeEmbed');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeMove;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeMove');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCAttributeMultiAttach;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAttributeMultiAttach');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCBezEdit;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBezEdit');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCBezierSingle;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBezierSingle');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCBooleanAdd (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBooleanAdd');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCBooleanIntersect (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBooleanIntersect');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCBooleanSubtract (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBooleanSubtract');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCBoundaryFill;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBoundaryFill');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCBoundaryHatch;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBoundaryHatch');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCChamfer;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChamfer');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCChangeAtbDisplay (var iError: Smallint; tfDisplay: WordBool);
type TVCProc = procedure (var iError: Smallint; tfDisplay: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeAtbDisplay');
    if @aproc <> nil then
      aproc(iError, tfDisplay);
  end;
end;

procedure VCChangeAtbLabelDisplay (var iError: Smallint; tfDisplay: WordBool);
type TVCProc = procedure (var iError: Smallint; tfDisplay: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeAtbLabelDisplay');
    if @aproc <> nil then
      aproc(iError, tfDisplay);
  end;
end;

procedure VCChangeSelected (var ea: EAttr);
type TVCProc = procedure (var ea: EAttr); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeSelected');
    if @aproc <> nil then
      aproc(ea);
  end;
end;

procedure VCChangeSymPlacementColor (var iError: Smallint; tfUsePlacementColor: WordBool; iNewColor: Smallint);
type TVCProc = procedure (var iError: Smallint; tfUsePlacementColor: WordBool; iNewColor: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeSymPlacementColor');
    if @aproc <> nil then
      aproc(iError, tfUsePlacementColor, iNewColor);
  end;
end;

procedure VCCircle2Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCircle2Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCCircle3Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCircle3Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCCircleDiameter;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCircleDiameter');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCClearDrawing (hW: Longint);
type TVCProc = procedure (hW: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCClearDrawing');
    if @aproc <> nil then
      aproc(hW);
  end;
end;

procedure VCClearDrawingNoPrompt (hW: Longint);
type TVCProc = procedure (hW: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCClearDrawingNoPrompt');
    if @aproc <> nil then
      aproc(hW);
  end;
end;

procedure VCContBezier;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCContBezier');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCCopySelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCopySelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCCopyToLayer (var iError: Smallint; iLayer: Smallint);
type TVCProc = procedure (var iError: Smallint; iLayer: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCopyToLayer');
    if @aproc <> nil then
      aproc(iError, iLayer);
  end;
end;

procedure VCCornerTrim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCornerTrim');
    if @aproc <> nil then
      aproc;
  end;
end;

function VCCreateOleClass (var iError: Smallint; OleDllName: PChar; OleClassName: PChar): Longint;
type TVCProc = function (var iError: Smallint; OleDllName: PChar; OleClassName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCreateOleClass');
    if @aproc <> nil then
      result := aproc(iError, OleDllName, OleClassName);
  end;
end;

procedure VCCurve;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCurve');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDatum (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDatum');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCDeleteOleClass (var iError: Smallint; id: Longint);
type TVCProc = procedure (var iError: Smallint; id: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDeleteOleClass');
    if @aproc <> nil then
      aproc(iError, id);
  end;
end;

procedure VCDeletePopupMenu (tf: WordBool);
type TVCProc = procedure (tf: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDeletePopupMenu');
    if @aproc <> nil then
      aproc(tf);
  end;
end;

procedure VCDestroyContextMenu (var iError: Smallint; hMenu: Longword);
type TVCProc = procedure (var iError: Smallint; hMenu: Longword); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDestroyContextMenu');
    if @aproc <> nil then
      aproc(iError, hMenu);
  end;
end;

procedure VCDiameterDim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDiameterDim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDigConfig;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDigConfig');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDigDrawingAlign;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDigDrawingAlign');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimEdit;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimEdit');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimMoveArc;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimMoveArc');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimMoveLine;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimMoveLine');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimMoveText;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimMoveText');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimPoint (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimPoint');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCDimSlideText;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimSlideText');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDispatchCommand;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDispatchCommand');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDispatchNextPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDispatchNextPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDllRun (var iError: Smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar);
type TVCProc = procedure (var iError: Smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDllRun');
    if @aproc <> nil then
      aproc(iError, DllName, FunctionName, CommandLine);
  end;
end;

procedure VCEdit;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEdit');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEditAbort;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEditAbort');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEditChange;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEditChange');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEditComplete;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEditComplete');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEllipse;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEllipse');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEllipticalArcStartSpan;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEllipticalArcStartSpan');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEraseLast;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEraseLast');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCEraseSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCEraseSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCExplode;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCExplode');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCExtend;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCExtend');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCFillSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCFillSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCFillet;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCFillet');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCFitScaleSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCFitScaleSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

function VCGetDatumMode (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetDatumMode');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

function VCGetCurrentToolContextMenu (var iError: Smallint; var hInMenu: Longword): WordBool;
type TVCProc = function (var iError: Smallint; var hInMenu: Longword): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetCurrentToolContextMenu');
    if @aproc <> nil then
      result := aproc(iError, hInMenu);
  end;
end;

function VCGetPrompt (iPromptIndex: Smallint; szPrompt: PChar): Smallint;
type TVCProc = function (iPromptIndex: Smallint; szPrompt: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrompt');
    if @aproc <> nil then
      result := aproc(iPromptIndex, szPrompt);
  end;
end;

function VCGetRibbolog: Word;
type TVCProc = function: Word; stdcall;
var aproc: TVCProc;
begin
  result := Word(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetRibbolog');
    if @aproc <> nil then
      result := aproc;
  end;
end;

function VCGetToolID: Word;
type TVCProc = function: Word; stdcall;
var aproc: TVCProc;
begin
  result := Word(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetToolID');
    if @aproc <> nil then
      result := aproc;
  end;
end;

function VCGetUserToolState (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetUserToolState');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

procedure VCGridOrigin;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGridOrigin');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCHatchSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCHatchSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCIrregularPolygon;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCIrregularPolygon');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLeader;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLeader');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLeaderEdit;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLeaderEdit');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLike (hw: Longint; ch: Shortint);
type TVCProc = procedure (hw: Longint; ch: Shortint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLike');
    if @aproc <> nil then
      aproc(hw, ch);
  end;
end;

procedure VCLine;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLine');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLineContinuous;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLineContinuous');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLinearDim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLinearDim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCLoadAscii (var iError: Smallint; szAscii: PChar);
type TVCProc = procedure (var iError: Smallint; szAscii: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadAscii');
    if @aproc <> nil then
      aproc(iError, szAscii);
  end;
end;

procedure VCLoadLnt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadLnt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMButtonDown (lParam: Longint; wParam: Word);
type TVCProc = procedure (lParam: Longint; wParam: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMButtonDown');
    if @aproc <> nil then
      aproc(lParam, wParam);
  end;
end;

procedure VCMLine;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMLine');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMatchEntity;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMatchEntity');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMatchTool;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMatchTool');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureAngle2;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureAngle2');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureAngle3;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureAngle3');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureArea;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureArea');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureDistance;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureDistance');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMerge (pName: PChar);
type TVCProc = procedure (pName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMerge');
    if @aproc <> nil then
      aproc(pName);
  end;
end;

procedure VCMergePolygonsTool (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMergePolygonsTool');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCMirrorSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMirrorSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCModBreak;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCModBreak');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMovePoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMovePoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMoveSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMoveSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMoveToLayer (var iError: Smallint; iLayer: Smallint);
type TVCProc = procedure (var iError: Smallint; iLayer: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMoveToLayer');
    if @aproc <> nil then
      aproc(iError, iLayer);
  end;
end;

procedure VCMultipleCopy;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMultipleCopy');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCNewHandle;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCNewHandle');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCOffsetMEP (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOffsetMEP');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCOffsetPnt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOffsetPnt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCOleClassMethodInvoke (var iError: Smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar);
type TVCProc = procedure (var iError: Smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOleClassMethodInvoke');
    if @aproc <> nil then
      aproc(iError, DllName, ClassName, MethodName, CmdLine);
  end;
end;

procedure VCOrdinateDim (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOrdinateDim');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCPackData (hW: Longint);
type TVCProc = procedure (hW: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPackData');
    if @aproc <> nil then
      aproc(hW);
  end;
end;

function VCPastable: WordBool;
type TVCProc = function: WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPastable');
    if @aproc <> nil then
      result := aproc;
  end;
end;

procedure VCPaste;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPaste');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCPlaceCurrentSymbol;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPlaceCurrentSymbol');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCPopupButton (lParam: Longint; wParam: Word);
type TVCProc = procedure (lParam: Longint; wParam: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPopupButton');
    if @aproc <> nil then
      aproc(lParam, wParam);
  end;
end;

procedure VCPurgeLnt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPurgeLnt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRButtonDown (lParam: Longint; wParam: Word);
type TVCProc = procedure (lParam: Longint; wParam: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRButtonDown');
    if @aproc <> nil then
      aproc(lParam, wParam);
  end;
end;

procedure VCRFSize (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFSize');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomAll (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomAll');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomArea (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomArea');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomIn (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomIn');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomOut (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomOut');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomPan (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomPan');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomPrevious (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomPrevious');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomRegen (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomRegen');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomValue (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomValue');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFZoomView (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFZoomView');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRPolygonCenter;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRPolygonCenter');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRPolygonSide;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRPolygonSide');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRadCopySelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRadCopySelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRadialDim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRadialDim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRectangle2Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRectangle2Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRectangle3Pt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRectangle3Pt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRedo;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRedo');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRefFrameCreate (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRefFrameCreate');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRefFramePlace (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRefFramePlace');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRegenArea;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRegenArea');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCReplaceSymbol (szFrom: PChar; szTo: PChar; tfSelectedOnly: WordBool);
type TVCProc = procedure (szFrom: PChar; szTo: PChar; tfSelectedOnly: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCReplaceSymbol');
    if @aproc <> nil then
      aproc(szFrom, szTo, tfSelectedOnly);
  end;
end;

procedure VCRotateSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRotateSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRun (szName: PChar);
type TVCProc = procedure (szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRun');
    if @aproc <> nil then
      aproc(szName);
  end;
end;

procedure VCRunNested (szName: PChar);
type TVCProc = procedure (szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRunNested');
    if @aproc <> nil then
      aproc(szName);
  end;
end;

procedure VCRunNestedDll;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRunNestedDll');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCScaleSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCScaleSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSeedFill;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSeedFill');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSeedHatch;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSeedHatch');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelect;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelect');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectAdjoining;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectAdjoining');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectCrossingWindow;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectCrossingWindow');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectLastEntity;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectLastEntity');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectLastObject (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectLastObject');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCSelectObject;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectObject');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectWindow;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectWindow');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectionExtend;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectionExtend');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectionFilter (CmdID: Word; id: Word);
type TVCProc = procedure (CmdID: Word; id: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectionFilter');
    if @aproc <> nil then
      aproc(CmdID, id);
  end;
end;

procedure VCSelectionRibalog (id: Word);
type TVCProc = procedure (id: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectionRibalog');
    if @aproc <> nil then
      aproc(id);
  end;
end;

procedure VCSelectionTrim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectionTrim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSelectionTrimSingleTarget (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSelectionTrimSingleTarget');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCSetBasepoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetBasepoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSetDatumMode (var iError: Smallint; iMode: Smallint);
type TVCProc = procedure (var iError: Smallint; iMode: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetDatumMode');
    if @aproc <> nil then
      aproc(iError, iMode);
  end;
end;

function VCSetPrompt (iPromptIndex: Smallint; szPrompt: PChar): WordBool;
type TVCProc = function (iPromptIndex: Smallint; szPrompt: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrompt');
    if @aproc <> nil then
      result := aproc(iPromptIndex, szPrompt);
  end;
end;

procedure VCSetRibbolog (id: Word);
type TVCProc = procedure (id: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetRibbolog');
    if @aproc <> nil then
      aproc(id);
  end;
end;

procedure VCSetUserTool (iStates: Smallint; szNativeCmd: PChar; szFirstPrompt: PChar);
type TVCProc = procedure (iStates: Smallint; szNativeCmd: PChar; szFirstPrompt: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetUserTool');
    if @aproc <> nil then
      aproc(iStates, szNativeCmd, szFirstPrompt);
  end;
end;

procedure VCSetUserToolState (var iError: Smallint; iNewState: Smallint);
type TVCProc = procedure (var iError: Smallint; iNewState: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetUserToolState');
    if @aproc <> nil then
      aproc(iError, iNewState);
  end;
end;

procedure VCSnapArcCenter;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapArcCenter');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapCloseGeom;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapCloseGeom');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapClosestPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapClosestPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapEndPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapEndPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapInt;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapInt');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapLastPoint (lParam: Longint; wParam: Word);
type TVCProc = procedure (lParam: Longint; wParam: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapLastPoint');
    if @aproc <> nil then
      aproc(lParam, wParam);
  end;
end;

procedure VCSnapMid2Points;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapMid2Points');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapMidPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapMidPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapNearPoint (lParam: Longint; wParam: Word);
type TVCProc = procedure (lParam: Longint; wParam: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapNearPoint');
    if @aproc <> nil then
      aproc(lParam, wParam);
  end;
end;

procedure VCSnapParallel;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapParallel');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapPercent;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapPercent');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapPerpendicular;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapPerpendicular');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapQuad;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapQuad');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSnapTangent;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSnapTangent');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSpecificAttributeAttach (lParam: Longint);
type TVCProc = procedure (lParam: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSpecificAttributeAttach');
    if @aproc <> nil then
      aproc(lParam);
  end;
end;

procedure VCSplitPolygonTool (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSplitPolygonTool');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCStretchSelected;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCStretchSelected');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSymbolCreate;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymbolCreate');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSymbolExplode;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymbolExplode');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSymbolPlace (szName: PChar);
type TVCProc = procedure (szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymbolPlace');
    if @aproc <> nil then
      aproc(szName);
  end;
end;

procedure VCTextManager;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTextManager');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCTextTool;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTextTool');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCTracking;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTracking');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCTrim;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTrim');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCUndo;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUndo');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCUndoLastVertex;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUndoLastVertex');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCUpdateTool;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUpdateTool');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCUserMatch (id: Word);
type TVCProc = procedure (id: Word); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUserMatch');
    if @aproc <> nil then
      aproc(id);
  end;
end;

procedure VCUserPoint;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUserPoint');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCWindowStretch;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCWindowStretch');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCZoomArea;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCZoomArea');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCZoomIn;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCZoomIn');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCZoomOut;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCZoomOut');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCZoomPan;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCZoomPan');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCZoomValue;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCZoomValue');
    if @aproc <> nil then
      aproc;
  end;
end;

function VCGetUserToolSnapable: WordBool;
type TVCProc = function: WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetUserToolSnapable');
    if @aproc <> nil then
      result := aproc;
  end;
end;

procedure VCSetUserToolSnapable (tf: WordBool);
type TVCProc = procedure (tf: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetUserToolSnapable');
    if @aproc <> nil then
      aproc(tf);
  end;
end;

procedure VCDivide;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDivide');
    if @aproc <> nil then
      aproc;
  end;
end;

end.
